/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.container.FluidExtractionModuleContainer;
import dev.quarris.ppfluids.container.FluidFilterModuleContainer;
import dev.quarris.ppfluids.container.FluidRetrievalModuleContainer;
import dev.quarris.ppfluids.items.FluidExtractionModuleItem;
import dev.quarris.ppfluids.items.FluidFilterModuleItem;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.items.FluidRetrievalModuleItem;
import dev.quarris.ppfluids.pipe.FluidPipeBlock;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="ppfluids", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ppfluids");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ppfluids");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"ppfluids");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"ppfluids");
    public static final RegistryObject<Block> FLUID_PIPE = BLOCKS.register("fluid_pipe", FluidPipeBlock::new);
    public static final RegistryObject<Item> FLUID_ITEM = ITEMS.register("fluid_item", FluidItem::new);
    public static final RegistryObject<BlockEntityType<FluidPipeBlockEntity>> FLUID_PIPE_TILE;
    public static final RegistryObject<MenuType<FluidFilterModuleContainer>> FLUID_FILTER_CONTAINER;
    public static final RegistryObject<MenuType<FluidExtractionModuleContainer>> FLUID_EXTRACTION_CONTAINER;
    public static final RegistryObject<MenuType<FluidRetrievalModuleContainer>> FLUID_RETRIEVAL_CONTAINER;

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITY_TYPES.register(bus);
        MENU_TYPES.register(bus);
    }

    private static void registerTieredModule(DeferredRegister<Item> registry, String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        for (ModuleTier tier : ModuleTier.values()) {
            String moduleName = tier.name().toLowerCase(Locale.ROOT) + "_" + name;
            registry.register(moduleName, () -> (ModuleItem)item.apply(name, tier));
        }
    }

    private static <T extends AbstractPipeContainer<?>> MenuType<T> createPipeContainer() {
        return IForgeMenuType.create((windowId, inv, data) -> {
            PipeBlockEntity tile = (PipeBlockEntity)Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)inv.f_35978_.f_19853_, (BlockPos)data.m_130135_());
            int moduleIndex = data.readInt();
            ItemStack moduleStack = tile.modules.getStackInSlot(moduleIndex);
            return ((IModule)moduleStack.m_41720_()).getContainer(moduleStack, tile, windowId, inv, inv.f_35978_, moduleIndex);
        });
    }

    static {
        ITEMS.register(FLUID_PIPE.getId().m_135815_(), () -> new BlockItem((Block)FLUID_PIPE.get(), new Item.Properties().m_41491_(Registry.TAB)));
        ModContent.registerTieredModule(ITEMS, "fluid_extraction_module", FluidExtractionModuleItem::new);
        ModContent.registerTieredModule(ITEMS, "fluid_filter_module", FluidFilterModuleItem::new);
        ModContent.registerTieredModule(ITEMS, "fluid_retrieval_module", FluidRetrievalModuleItem::new);
        IPipeItem.TYPES.put(FluidPipeItem.FLUID_TYPE, FluidPipeItem::new);
        FLUID_PIPE_TILE = BLOCK_ENTITY_TYPES.register("fluid_pipe", () -> BlockEntityType.Builder.m_155273_(FluidPipeBlockEntity::new, (Block[])new Block[]{(Block)FLUID_PIPE.get()}).m_58966_(null));
        FLUID_FILTER_CONTAINER = MENU_TYPES.register("fluid_filter", ModContent::createPipeContainer);
        FLUID_EXTRACTION_CONTAINER = MENU_TYPES.register("fluid_extraction", ModContent::createPipeContainer);
        FLUID_RETRIEVAL_CONTAINER = MENU_TYPES.register("fluid_retrieval", ModContent::createPipeContainer);
    }
}

